﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using PpmsDataWebService.Models;
using VA.PPMS.Context;

namespace PpmsDataWebService.Mappers
{
    public class ProviderLicensesMap
    {
        public static async Task<IQueryable<ProviderLicense>> MapProviderLicenses(List<ppms_providerlicensure> ppmsProviderLicenses, string mapRelatedType, PpmsContext context)
        {
            var providerLicenses = new List<ProviderLicense> {};
            foreach (var ppmsProviderLicense in ppmsProviderLicenses)
            {                                              
                    var providerLicense = new ProviderLicense
                    {
                        LicenseNumber = ppmsProviderLicense.ppms_name,
                        LicensingState = ppmsProviderLicense.ppms_licensingstate
                    };
                    if (ppmsProviderLicense.ppms_expirationdate != null) { providerLicense.ExpirationDate = ppmsProviderLicense.ppms_expirationdate.ToString(); }


                if (mapRelatedType.Contains("?$expand=Provider"))
                    mapRelatedType = "Provider";

                //Map Related Types
                switch (mapRelatedType)
                {
                    case "Provider":
                        //Lookup and Map the Provider
                        var ppmsProvider =
                            context.AccountSet.FirstOrDefault(i => i.Id == ppmsProviderLicense.ppms_ProviderIdId.Id);
                        var ppmsProvidersList = new List<Account> { ppmsProvider };
                        providerLicense.Provider =
                            await ProviderMap.MapProviders(ppmsProvidersList, "None");
                        break;
                    default:
                        break;
                }
                providerLicenses.Add(providerLicense);                                 
            }
            return providerLicenses.AsQueryable();            
        }       
    }
}